#include <common.h>
#include <command.h>
#include "accton_lib.h"
#include "ams_ucmgr.h"
//#include <linux/string.h>

int Accton_UC_Update_Version(char * ver, unsigned long pid)
{
    UC_MGR_Sys_Info_T uc_info;
    if(UC_MGR_GetSysInfo(&uc_info))
    {
        if((uc_info.project_id&0x7FFF) != (pid&0x7FFF))
        {
            //printf("Wrong project ID for runtime image!, abort!\r\n");
            return -1;
        }
        strncpy((char *)uc_info.runtime_fw_ver, (char *)ver, sizeof(uc_info.runtime_fw_ver));
        sprintf((char *)uc_info.module_expected_runtime_fw_ver, "0.0.0.0");    /*So far, we do not support multi-file image */
        return (UC_MGR_SetSysInfo(&uc_info)==TRUE)?0:1;
    }

    return 0;
}

